/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html.contentassist;

import com.aptana.core.IFilter;
import com.aptana.core.IMap;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.FileUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.hover.TagStripperAndTypeBolder;
import com.aptana.editor.html.contentassist.Messages;
import com.aptana.editor.html.contentassist.model.AttributeElement;
import com.aptana.editor.html.contentassist.model.BaseElement;
import com.aptana.editor.html.contentassist.model.ElementElement;
import com.aptana.editor.html.contentassist.model.SpecificationElement;
import com.aptana.editor.html.contentassist.model.UserAgentElement;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTMLModelFormatter {
    private static final String HTML_NEWLINE = "<br>";
    public static final HTMLModelFormatter TEXT_HOVER = new HTMLModelFormatter(true, Section.NAME, Section.DISPLAY_NAME, Section.DESCRIPTION, Section.REMARK, Section.EXAMPLE, Section.SPECIFICATIONS);
    private List<Section> fSections;
    private boolean useHTML;

    private HTMLModelFormatter(boolean useHTML, Section ... sectionsToDisplay) {
        this.fSections = Arrays.asList(sectionsToDisplay);
        this.useHTML = useHTML;
        for (Section s : this.fSections) {
            s.useHTML = useHTML;
        }
    }

    public String getHeader(BaseElement element) {
        return this.getHeader(CollectionsUtil.newList((Object[])new BaseElement[]{element}));
    }

    public String getHeader(final Collection<BaseElement> elements) {
        if (CollectionsUtil.isEmpty(elements)) {
            return "";
        }
        ArrayList<String> stringParts = new ArrayList<String>(this.fSections.size() + 2);
        if (this.useHTML) {
            stringParts.add("<b>");
        }
        List headerSections = CollectionsUtil.filter(this.fSections, (IFilter)new IFilter<Section>(){

            public boolean include(Section item) {
                return item.isHeader();
            }
        });
        stringParts.addAll(CollectionsUtil.map((Collection)headerSections, (IMap)new IMap<Section, String>(){

            public String map(Section s) {
                return s.generate(elements, null);
            }
        }));
        if (this.useHTML) {
            stringParts.add("</b>");
        }
        return StringUtil.concat(stringParts);
    }

    public String getDocumentation(BaseElement element) {
        return this.getDocumentation(CollectionsUtil.newList((Object[])new BaseElement[]{element}));
    }

    public String getDocumentation(final Collection<BaseElement> elements) {
        List docSections = CollectionsUtil.filter(this.fSections, (IFilter)new IFilter<Section>(){

            public boolean include(Section s) {
                return !s.isHeader();
            }
        });
        List sectionStrings = CollectionsUtil.map((Collection)docSections, (IMap)new IMap<Section, String>(){

            public String map(Section s) {
                return s.generate(elements, null);
            }
        });
        return StringUtil.concat((Collection)sectionStrings);
    }

    protected String newline() {
        return this.useHTML ? HTML_NEWLINE : FileUtil.NEW_LINE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class Section {
        protected boolean useHTML;
        private String name;
        static final Section NAME = new Section("NAME"){

            @Override
            public boolean isHeader() {
                return true;
            }

            @Override
            public String generate(Collection<BaseElement> elements, URI root) {
                BaseElement prop = elements.iterator().next();
                return prop.getName();
            }
        };
        static final Section DISPLAY_NAME = new Section("DISPLAY_NAME"){

            @Override
            public boolean isHeader() {
                return true;
            }

            @Override
            public String generate(Collection<BaseElement> elements, URI root) {
                BaseElement prop = elements.iterator().next();
                if (!(prop instanceof ElementElement)) {
                    return "";
                }
                return MessageFormat.format(Messages.HTMLModelFormatter_DisplayName, ((ElementElement)prop).getDisplayName());
            }
        };
        static final Section EXAMPLE = new Section("EXAMPLE"){

            @Override
            public String generate(Collection<BaseElement> elements, URI root) {
                String example = this.getFirstExample(elements);
                return this.addSection(Messages.HTMLModelFormatter_ExampleSection, example);
            }

            private String getFirstExample(Collection<BaseElement> elements) {
                for (BaseElement prop : elements) {
                    ElementElement el;
                    String example;
                    if (!(prop instanceof ElementElement) || StringUtil.isEmpty((String)(example = (el = (ElementElement)prop).getExample()))) continue;
                    return example;
                }
                return "";
            }
        };
        static final Section EXAMPLES = new Section("EXAMPLES"){

            @Override
            public String generate(Collection<BaseElement> elements, URI root) {
                List<String> examples = new ArrayList();
                for (BaseElement prop : elements) {
                    if (!(prop instanceof ElementElement)) continue;
                    ElementElement el = (ElementElement)prop;
                    examples.add(el.getExample());
                }
                if ((examples = CollectionsUtil.filter(examples, (IFilter)new IFilter<String>(){

                    public boolean include(String item) {
                        return !StringUtil.isEmpty((String)item);
                    }
                })).size() == 1) {
                    return this.addSection(Messages.HTMLModelFormatter_ExampleSection, (String)examples.get(0));
                }
                ArrayList<String> builder = new ArrayList<String>();
                int i = 0;
                while (i < examples.size()) {
                    builder.add(this.addSection(MessageFormat.format("Example {0}", i + 1), (String)examples.get(i)));
                    ++i;
                }
                return StringUtil.concat(builder);
            }
        };
        static final Section REMARK = new Section("REMARK"){

            @Override
            public String generate(Collection<BaseElement> elements, URI root) {
                String remark = this.getFirstRemark(elements);
                return this.addSection(Messages.HTMLModelFormatter_RemarksSection, remark);
            }

            private String getFirstRemark(Collection<BaseElement> elements) {
                for (BaseElement prop : elements) {
                    String remark = null;
                    if (prop instanceof ElementElement) {
                        ElementElement el = (ElementElement)prop;
                        remark = el.getRemark();
                    } else if (prop instanceof AttributeElement) {
                        AttributeElement at = (AttributeElement)prop;
                        remark = at.getRemark();
                    }
                    if (StringUtil.isEmpty(remark)) continue;
                    return remark;
                }
                return "";
            }
        };
        static final Section SPECIFICATIONS = new Section("SPECIFICATIONS"){

            @Override
            public String generate(Collection<BaseElement> properties, URI root) {
                HashSet<SpecificationElement> specs = new HashSet<SpecificationElement>();
                for (BaseElement property : properties) {
                    List<Object> someSpecs = Collections.emptyList();
                    if (property instanceof ElementElement) {
                        ElementElement el = (ElementElement)property;
                        someSpecs = el.getSpecifications();
                    } else if (property instanceof AttributeElement) {
                        AttributeElement at = (AttributeElement)property;
                        someSpecs = at.getSpecifications();
                    }
                    specs.addAll(someSpecs);
                }
                return this.addSection(Messages.HTMLModelFormatter_SpecificationSection, this.getSpecificationsString(specs));
            }

            private String getSpecificationsString(Collection<SpecificationElement> specs) {
                List strings = CollectionsUtil.map(specs, (IMap)new IMap<SpecificationElement, String>(){

                    public String map(SpecificationElement item) {
                        StringBuilder b = new StringBuilder();
                        b.append(item.getName());
                        String version = item.getVersion();
                        if (!StringUtil.isEmpty((String)version)) {
                            b.append(": ").append(version);
                        }
                        return b.toString();
                    }
                });
                return StringUtil.join((String)", ", (Collection)strings);
            }
        };
        static final Section DESCRIPTION = new Section("DESCRIPTION"){
            private TagStripperAndTypeBolder stripAndBold = new TagStripperAndTypeBolder();

            @Override
            public String generate(Collection<BaseElement> properties, URI root) {
                HashSet<String> descriptions = new HashSet<String>();
                for (BaseElement property : properties) {
                    this.stripAndBold.setUseHTML(this.useHTML);
                    String desc = this.stripAndBold.searchAndReplace(property.getDescription());
                    if (StringUtil.isEmpty((String)desc)) continue;
                    descriptions.add(desc);
                }
                if (CollectionsUtil.isEmpty(descriptions)) {
                    return Messages.HTMLModelFormatter_NoDescription;
                }
                return StringUtil.join((String)", ", descriptions);
            }
        };
        static final Section PLATFORMS = new Section("PLATFORMS"){

            @Override
            public String generate(Collection<BaseElement> elements, URI root) {
                HashSet<UserAgentElement> userAgents = new HashSet<UserAgentElement>();
                for (BaseElement property : elements) {
                    List<Object> ua = Collections.emptyList();
                    if (property instanceof ElementElement) {
                        ElementElement element = (ElementElement)property;
                        ua = element.getUserAgents();
                    } else if (property instanceof AttributeElement) {
                        AttributeElement at = (AttributeElement)property;
                        ua = at.getUserAgents();
                    }
                    userAgents.addAll(ua);
                }
                return this.addSection(Messages.HTMLModelFormatter_SupportedPlatforms, this.getPlatforms(userAgents));
            }

            private String getPlatforms(Collection<UserAgentElement> userAgents) {
                List strings = CollectionsUtil.map(userAgents, (IMap)new IMap<UserAgentElement, String>(){

                    public String map(UserAgentElement item) {
                        StringBuilder b = new StringBuilder();
                        b.append(item.getPlatform());
                        String version = item.getVersion();
                        if (!StringUtil.isEmpty((String)version)) {
                            b.append(": ").append(version);
                        }
                        return b.toString();
                    }
                });
                return StringUtil.join((String)", ", (Collection)strings);
            }
        };

        private Section(String name) {
            this.name = name;
        }

        public boolean isHeader() {
            return false;
        }

        private String newline() {
            return this.useHTML ? HTMLModelFormatter.HTML_NEWLINE : FileUtil.NEW_LINE;
        }

        protected String addSection(String title, String value) {
            StringBuilder builder = new StringBuilder();
            if (!StringUtil.isEmpty((String)value)) {
                builder.append(this.newline()).append(this.newline());
                if (this.useHTML) {
                    builder.append("<b>");
                }
                builder.append(title);
                if (this.useHTML) {
                    builder.append("</b>");
                }
                builder.append(this.newline());
                builder.append(value.trim());
            }
            return builder.toString();
        }

        public String toString() {
            return this.name;
        }

        public abstract String generate(Collection<BaseElement> var1, URI var2);
    }
}

